//%attributes = {}
// Method: pr_ AmountStock1ToDesign1
// 2005.09.09-15:39:05 / Pasi Mankinen
// © Copyright 2005 Manage Applications
// Purpose: Converts amount from stock unit 1 to design unit 1
// 
// ------------------------------------------------------------
C_REAL:C285($0; $1; $2)
C_LONGINT:C283($3)  //round value to default decimals
C_REAL:C285($pr_rStock1Amount; $pr_rDesign1Amount; $pr_rMultiplier)

$pr_rStock1Amount:=$1
$pr_rMultiplier:=$2

If ($pr_rMultiplier=kGet)  //-10022
	If (_rec Loaded(pr_kTbl)=kFalse)
		_err MESSAGE(_lang Current("Product record is not loaded, conversion multiplier can not be loaded"); Current method name:C684; kTrue)
	Else 
		$pr_rMultiplier:=_fld ValueReal(pr_kUnit__Design_Unit_Multip)
	End if 
End if 

Case of 
	: ($pr_rMultiplier=0)
		$pr_rDesign1Amount:=0
	: ($pr_rMultiplier#-1)
		// from unit 1 to unit 2 we need to divide  
		$pr_rDesign1Amount:=$pr_rStock1Amount/$pr_rMultiplier
	Else   //-1 = inverse number
		If ($pr_rStock1Amount#0)
			$pr_rDesign1Amount:=1/$pr_rStock1Amount
		Else 
			$pr_rDesign1Amount:=0
		End if 
End case 

If ($3=kTrue)
	$pr_rDesign1Amount:=Round:C94($pr_rDesign1Amount; <>pr_iPyörMäär)
End if 
$0:=$pr_rDesign1Amount
